/*
 * Name:		James Sheets
 * Class:	CIS 285
 * Due:		2/22/07
 * Desc:		GUI program to take input from a file, or directly input from user.
 *				The data can be assumed to be all numbers.  Allow person to specify
 *				a search number, then perform the search, and echo back the number
 *				of matches found (This is primarily a CVS test)
*/
 
import javax.swing.*;
import java.awt.Dimension;
import java.awt.BorderLayout;
import java.awt.Toolkit;
import java.awt.*;
import java.awt.event.*;
import java.util.StringTokenizer;
import java.io.FileReader;
import java.io.BufferedReader;

/*
 * Simply class to provide Main() method
*/
class Client
{
	/*
	 * Program entry-point
	*/
	public static void main(String[] args)
	{
		try{
        UIManager.setLookAndFeel( UIManager.getSystemLookAndFeelClassName() );
		} catch (Exception e) { }
		GUI frame = new GUI();
	}
}


/*
 * Class where all the work is done
*/
class GUI extends JFrame implements ActionListener
{
	// Globals
	JButton start;
	JTextArea data;
	JTextField file;
	JButton fileC;
	JFileChooser chooser;
	JTextField search;
	int[] searchData;
	JComboBox searchSelect;
	
	
	/*
	 * Constructor for our class
	*/
	public GUI()
	{
		super("Search Program");
		this.setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );
		
		// Create the area to select a file
		JLabel fileL = new JLabel("File to search");
		file = new JTextField(21);
		fileC = new JButton("Select File");
		fileC.setName("fileButton");
		JPanel one = new JPanel();
		one.add(fileL, BorderLayout.WEST);
		one.add(file, BorderLayout.CENTER);
		one.add(fileC, BorderLayout.EAST);
		
		// Create the area to input raw numbers
		JLabel dataL = new JLabel("Data to search");
		data = new JTextArea(10,30);
		JPanel two = new JPanel();
		two.add(dataL, BorderLayout.WEST);
		two.add(new JScrollPane(data), BorderLayout.EAST);
		
		// Create the area to input a number to search for
		JLabel searchL = new JLabel("Number to search for");
		search = new JTextField(5);
		JPanel three = new JPanel();
		three.add(searchL, BorderLayout.WEST);
		three.add(search, BorderLayout.EAST);
		
		// Create combobox to choose search type
		String[] searchTypes = {"Iterative","Sorted"};
		JLabel searchTypesL = new JLabel("Select search algorithm");
		searchSelect = new JComboBox(searchTypes);
		JPanel four = new JPanel();
		four.add(searchTypesL, BorderLayout.WEST);
		four.add(searchSelect, BorderLayout.EAST);
		
		// Create the search button
		start = new JButton("Start Search");
		start.setName("startButton");
		
		// Add everything to the frame
		GridBagConstraints c = new GridBagConstraints();
		c.gridwidth = GridBagConstraints.REMAINDER;
		this.getContentPane().setLayout(new GridBagLayout());
		this.getContentPane().add(one,c);
		this.getContentPane().add(two,c);
		this.getContentPane().add(three,c);
		this.getContentPane().add(four,c);
		this.getContentPane().add(start,c);
		
		// Add action listenerss
		fileC.addActionListener(this);
		start.addActionListener(this);
		
		// Display frame
		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
		this.pack();
		this.setLocation( 
			(screen.width - this.getSize().width)/2, 
			(screen.height - this.getSize().height)/2 
		);
		this.setResizable(false);
		this.setVisible(true);
	}
	
	
	/*
	 * Display a warning message to the user
	*/
	public void warning(String s)
	{
		// Display message in a dialog box
		JOptionPane.showMessageDialog(this, s);
	}
	
	
	/*
	 * Create the array of search variables
	 * fromFile = true: get data from file
	 * fromFile = false: get data from text area
	*/
	public void getData(boolean fromFile)
	{
		// Get the data from a file
		String rawData = new String("");
		if (fromFile)
		{
			try 
			{
				// Open the file
				FileReader input = new FileReader(file.getText());
				BufferedReader bufRead = new BufferedReader(input);
				
				// Read in the data
				boolean eof = false;
				while (!eof) 
				{
					String line = bufRead.readLine();
					if (line == null) eof = true;
					else rawData += line + " ";
				}
				
				bufRead.close();
			}
			catch (Exception e)
			{
				warning("Error reading file");
			}
		}
		// Get the data from the text area
		else
		{
			rawData = data.getText();
		}
		
		// Use regex to split the input into an array of strings
		String[] result = rawData.split("\\s|\\n");
		
		try 
		{
			// Convert each string to an int, save it in our global array
			searchData = new int[result.length];
			for (int x=0; x<result.length; x++)
			{
				Integer val = Integer.parseInt(result[x]);
				searchData[x] = val.intValue();
			}
		}
		catch (NumberFormatException e)
		{
			if (fromFile)
				warning("The data in your file must contain only integers.");
			else
				warning("The data in the text area must contain only integers.");
		}
	}
	
	
	/*
	 * Perform our search
	*/
	public void search()
	{
		try 
		{
			// Convert string to int
			Integer searchValueObj = Integer.parseInt(search.getText().trim());
			int searchValue = searchValueObj.intValue();
			
			// Get the search type chosen in our combo box
			String pattern = (String)searchSelect.getSelectedItem();
			// Get an instance of our search pattern, pass in search data
			SearchPatterns searchPattern = null;
			if (pattern.equals("Iterative"))
				searchPattern = new IterativeSearch(searchData);
			else if (pattern.equals("Sorted"))
				searchPattern = new SortedSearch(searchData);
			
			// Perform the search
			int matches = searchPattern.find(searchValue);
			// Output the search results
			warning("There are " + matches + " occurances of the number " + searchValue);
		}
		catch (NumberFormatException e)
		{
			warning("Your search number must be an integer.");
		}
	}
	
	
	/*
	 * Action listenter, where all our events occur
	*/
	public void actionPerformed(ActionEvent ae)
	{
		// Figure out which component triggered the event
		Object source = ae.getSource();
		if (source instanceof Component)
		{
			Component comp = (Component)source;
			
			// If the start button was pressed, attempt to perform the search
			if (comp.getName().equals("startButton"))
			{
				if (!search.getText().isEmpty())
				{
					// Attempt to search the file
					if (!file.getText().isEmpty())
					{
						getData(true);
						search();
					}
					// Attempt to search the input data
					else if (!data.getText().isEmpty())
					{
						getData(false);
						search();
					}
					// Give error
					else
					{
						warning("You need to enter a valid file to search, or enter the data in the text area");
					}
				}
				// Give error
				else
				{
					warning("You need to input a search integer");
				}
			}
			
			// If the file chooser button was pressed, display the chooser dialog
			else if (comp.getName().equals("fileButton"))
			{
				chooser = new JFileChooser();
				int returnVal = chooser.showOpenDialog(this);
				// When a file is chosen, put its path in the file text field
				if(returnVal == JFileChooser.APPROVE_OPTION) 
					file.setText( chooser.getSelectedFile().getAbsolutePath() );
			}
			
		}
	}
	
}